#!/bin/bash

CHUNKS=8
output_dir="./blob_dir/debug_output/llava/exp/llava-7b-science_qa-finetune/2x8GPU_bsz2_gacc1_lr2e-5_probable-bluejay"
output_file=${output_dir}/test_pred.jsonl

# Clear out the output file if it exists.
> "$output_file"

# Loop through the indices and concatenate each file.
for idx in $(seq 0 $((CHUNKS-1))); do
  cat "${output_dir}/test_pred-chunk${idx}.jsonl" >> "$output_file"
done

python llava/eval/eval_science_qa.py \
    --base-dir ./datasets/ScienceQA/ \
    --result-file $output_file \
    --output-file ${output_dir}/test_output.json \
    --output-result ${output_dir}/test_result.json
